---
title: Reranking and API-based system prompt configuration in AI Search · Changelog
description: Improve result accuracy with reranking and dynamically control AI
  Search responses by setting system prompts in API requests.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-27-ai-search-reranking-system-prompt/
  md: https://developers.cloudflare.com/changelog/2025-10-27-ai-search-reranking-system-prompt/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Reranking and API-based system prompt configuration in AI Search

Oct 28, 2025

[AI Search](https://developers.cloudflare.com/ai-search/)

[AI Search](https://developers.cloudflare.com/ai-search/) now supports reranking for improved retrieval quality and allows you to set the system prompt directly in your API requests.

#### Rerank for more relevant results

You can now enable [reranking](https://developers.cloudflare.com/ai-search/configuration/reranking/) to reorder retrieved documents based on their semantic relevance to the user’s query. Reranking helps improve accuracy, especially for large or noisy datasets where vector similarity alone may not produce the optimal ordering.

You can enable and configure reranking in the dashboard or directly in your API requests:

```javascript
const answer = await env.AI.autorag("my-autorag").aiSearch({
  query: "How do I train a llama to deliver coffee?",
  model: "@cf/meta/llama-3.3-70b-instruct-fp8-fast",
  reranking: {
    enabled: true,
    model: "@cf/baai/bge-reranker-base"
  }
});
```

#### Set system prompts in API

Previously, [system prompts](https://developers.cloudflare.com/ai-search/configuration/system-prompt/) could only be configured in the dashboard. You can now define them directly in your API requests, giving you per-query control over behavior. For example:

```javascript
// Dynamically set query and system prompt in AI Search
async function getAnswer(query, tone) {
  const systemPrompt = `You are a ${tone} assistant.`;


  const response = await env.AI.autorag("my-autorag").aiSearch({
    query: query,
    system_prompt: systemPrompt
  });


  return response;
}


// Example usage
const query = "What is Cloudflare?";
const tone = "friendly";


const answer = await getAnswer(query, tone);
console.log(answer);
```

Learn more about [Reranking](https://developers.cloudflare.com/ai-search/configuration/reranking/) and [System Prompt](https://developers.cloudflare.com/ai-search/configuration/system-prompt/) in AI Search.
