---
title: Overview · Cloudflare Email security (formerly Area 1) docs
description: Phishing is the root cause of upwards of 90% of breaches that lead
  to financial loss and brand damage. Email Security (formerly Area 1) is a
  cloud-native service that stops phishing attacks across all threat vectors
  either at the edge or in the cloud.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/
  md: https://developers.cloudflare.com/email-security/index.md
---

Stop phishing attacks with Email security (formerly Area 1) cloud-native email security service.

Available on paid plans

Area 1 has been renamed

Area 1 is now **Email security (formerly Area 1)**. Customers who purchased the new Email security can access the documentation by going to Cloudflare Zero Trust > [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/).

Access to Area 1

Beginning October 1, 2025, access and support for Email Security (formerly Area 1) will only be available through the Cloudflare dashboard. Your Email Security protection will not change, but you will no longer be able to access the Area 1 dashboard or send support requests to `@area1security.com` email addresses. For help accessing the Cloudflare dashboard, reach out to <successteam@cloudflare.com>.

Phishing is the root cause of upwards of 90% of breaches that lead to financial loss and brand damage. Email Security (formerly Area 1) is a cloud-native service that stops phishing attacks across all threat vectors either at the [edge](https://www.cloudflare.com/learning/serverless/glossary/what-is-edge-computing/) or in the cloud.

With globally distributed sensors and comprehensive attack analytics, Email Security (formerly Area 1) proactively identifies phishing campaigns, attacker infrastructure, and attack delivery mechanisms during the earliest stages of a phishing attack cycle. Using flexible enforcement platforms, the Email Security (formerly Area 1) solution allows customers to take preemptive action against targeted phishing, including malware, spoofing attacks, payload-less Business Email Compromise attacks, supply chain phishing, and other advanced threats.

***

## Features

### Deployment

Email security (formerly Area 1) provides two architectures to protect your organization: inline or API setup. Inline architecture evaluates email messages before they reach a user's inbox. API architecture evaluates emails when they have already reached a user's inbox.

[Evaluate deployment options](https://developers.cloudflare.com/email-security/deployment/)

### SSO integration

In addition to standard logins, Email security (formerly Area 1) offers support for SAML based single sign-on (SSO) logins to your dashboard.

[Use SSO integration](https://developers.cloudflare.com/email-security/account-setup/sso/)

### Business email compromise

Attackers often try to impersonate executives within an organization when sending malicious emails. The Business email compromise (BEC) feature protects against these attacks.

[Use Business email compromise](https://developers.cloudflare.com/email-security/email-configuration/enhanced-detections/business-email-compromise/)

***

## Related products

**[Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/)**

Cloudflare Zero Trust replaces legacy security perimeters with Cloudflare's global network, making the Internet faster and safer for teams around the world.

**[Email Routing](https://developers.cloudflare.com/email-routing/)**

Email Routing simplifies the way you create and manage custom email addresses. Email security (formerly Area 1) helps secure your mail infrastructure from phishing attacks.

**[DMARC Management](https://developers.cloudflare.com/dmarc-management/)**

Stop brand impersonation. Track and manage every source that is sending emails from your domain.

***

## More resources

[Pricing](https://www.cloudflare.com/products/zero-trust/email-security/)

Email security (formerly Area 1) is available as a standalone product purchase.
