---
title: Redirect local visitors to specific subdomains · Cloudflare Rules docs
description: Create a redirect rule to redirect United Kingdom and France
  visitors from the `example.com` website's  root path (`/`) to their localized
  subdomains `https://gb.example.com` and `https://fr.example.com`,
  respectively.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-country-subdomains/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-country-subdomains/index.md
---

This example single redirect for zone `example.com` will redirect United Kingdom and France visitors requesting the website's root path (`/`) to their localized subdomains `https://gb.example.com` and `https://fr.example.com`, respectively.

**When incoming requests match**

Using the Expression Editor:\
`(ip.src.country eq "GB" or ip.src.country eq "FR") and http.request.uri.path eq "/"`

**Then**

* **Type:** *Dynamic*
* **Expression:** `lower(concat("https://", ip.src.country, ".example.com"))`
* **Status code:** *301*

For example, the redirect rule would perform the following redirects:

| Visitor country | Request URL | Target URL | Status code |
| - | - | - | - |
| United Kingdom | `example.com` | `https://gb.example.com` | `301` |
| France | `example.com` | `https://fr.example.com` | `301` |
| United States | `example.com` | (unchanged) | n/a |
