---
title: HTTP/3 (with QUIC) · Cloudflare Speed docs
description: HTTP/3 uses QUIC, which is a secure-by-default transport protocol.
  HTTP/3 improves page load times in a similar way to HTTP/2. However, the QUIC
  transport protocol solves TCP's head-of-line blocking problem, meaning that
  performance over lossy networks can be better.
lastUpdated: 2024-12-16T22:33:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/optimization/protocol/http3/
  md: https://developers.cloudflare.com/speed/optimization/protocol/http3/index.md
---

HTTP/3 uses QUIC, which is a secure-by-default transport protocol. HTTP/3 improves page load times in a similar way to HTTP/2. However, the QUIC transport protocol solves TCP's head-of-line blocking problem, meaning that performance over lossy networks can be better.

Note

For more background on HTTP/3, visit the [Learning Center](https://www.cloudflare.com/learning/performance/what-is-http3/).

Note

This setting is for connection between the user and Cloudflare. HTTP/3 connection to the origin is not yet supported.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

## Enable HTTP/3

HTTP/3 is available to all plans (though it does require an [SSL certificate at Cloudflare’s edge network](https://developers.cloudflare.com/ssl/get-started/)).

* Dashboard

  To enable **HTTP/3** in the dashboard:

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
  2. Select your account and zone.
  3. Go to **Speed** > **Optimization**.
  4. Go to **Protocol Optimization**.
  5. For **HTTP/3**, switch the toggle to **On**.

* API

  To enable **HTTP/3** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `http3` as the setting name in the URI path, and the `value` parameter set to `"on"`.
